#!perl
##############################################################################
#
# Title:  Quick Check template for App Kit based Recovery Kits
#
# Description:
#   The Quick Check script is used to quickly assess the current
#   operational state of the protected application. 
#   It should return 0 if the resource is functioning properly or if
#   resource does not exist or the script fails for some unknown reason.
#   It should return non-0 only in the case of resource failure. 
#   This template must be customized to your specific application.
#
# Usage:  quickchk -t tagname -i id
#
#         where:
#         "tagname" is the resource tag name
#          "id" is the resource ID
#
# Return code:
#   0 - quickchk successful
#   1 - quickchk failed
#
#   Since quickchk may be called frequently to determine the resource
#   state, it should not generate log entries if the resource is found
#   to be functioning properly.  However, if the resource is not 
#   functioning properly an error should be logged as illlustrated below.
#
# This script is assigned an error code range 27650 - 27699
################### LifeKeeper for  Windows CHANGE LOG #######################
#
#      CR        DATE     DEV     DESCRIPTION 
# =============  =======  ======  ====================================
# lkwin00000588  03/21/02 drk     submit for gen/app kit
# lkwin00001203  08/07/03 lcg     Quote tag name & id
# 0001           10/19/16 drk     Get IP List from INFO field.
#
##############################################################################
#
##### User define variables 
##### you must be describe Ping address for detection IP fail.
##### example @PingList=("10.1.6.249" ,"10.1.6.189");
#@PingList=('10.1.6.18' ,'10.1.6.22' ,'10.1.6.44' ,'10.1.6.13' ,'10.1.6.230' ,'10.1.6.249' ,'10.1.6.189');
#@PingList=('10.2.1.216' ,'10.2.1.217' ,'10.2.1.218');

#####
BEGIN { require $ENV{'LKROOT'}.'/etc/default/LifeKeeper.pl'; }

use LK;
use POSIX;
use Getopt::Std; # use the standard getopt package

$LKROOT=$ENV{'LKROOT'};
$ResType="app";
$AppType="gen";
$CMD=`basename $0`;
chomp $CMD;

sub parseOptions { # noparams

	getopts('t:i:');
	$tag = "$opt_t";
	$id = "$opt_i";
};

# 0001 - Retrieve INFO field.
sub getResourceInfo {						# subroutine argument(s):  resource tag 
	my $tag = shift;					# pick up tag field argument
	@_ = LK::ins_list('', '', '', '', $tag, '');		# get resource instance data
	@_ = split /\001/, $_[0];				# fields are Ctrl-A delimited; parse them
	return $_[5];						# return the resource info (6th field) 
};

############################
# Main execution begins here
############################

# Parse command line options
parseOptions;

# 0001 Get IP Ping List from INFO Field
my $IPList = getResourceInfo($tag);
if (!IPList) {	# is the info field null?
	`$LKBIN/lk_err -c FRS_ERR -n 27454 -d TO_STDERR -p $CMD "LifeKeeper: Windows IP Companion App RESTORE; The $tag resource info field is null."`;
	exit 1;
}
@PingList = split(" ",$IPList);

######################################################
# Standard setup is done, now perform the desired task
######################################################

# Perform commands that quickly assess the state of the protected application

# -------------------------------------------------------------------------------------
#                     Custom code goes here
$pingcheckfail = 1;
$retry = 0;
foreach $PingAddress ( @PingList ) {
#ping results getting(if fail this value will be null)

	printf("PingAddress is %s\r\n", $PingAddress );
	if ( $PingAddress eq '' ) {
		$RetCode = 200; # empty ping address
		next;
	}

	$pingresults =  `ping -n 1 $PingAddress | findstr /c:"TTL="`;
	printf("Pingresults is %s\r\n", $pingresults );
	if ( $pingresults eq '') {
		$pingcheckfail = 1;
	} else {
		$pingcheckfail = 0;
		printf("Pass list #%d IP=%s \r\n",$retry,$PingAddress);
		last; # if ping results not null exit loop
	}
		
	printf("Trying list #%d IP=%s ping fail\r\n",$retry,$PingAddress);
	$retry++;

	sleep 1;
}
$RetCode = $pingcheckfail;
# -------------------------------------------------------------------------------------

# RetCode is used to identify successful or failed Quick Check 
# $RetCode = $?>>8; # In perl, the application return code is offset 8 bits.
if ( $RetCode != 0 )
{
	# Test has failed
	`$ENV{'LKROOT'}/bin/lk_err -c FRS_ERR -n 27655 -d TO_STDERR -p $CMD "LifeKeeper: TAG=\\"$tag\\", ID=\\"$id\\";  Quick Check for Resource has FAILED.  Return code is \\"$RetCode\\" "`;
	exit $RetCode;
}

# All tests passed, return success.
exit 0;
