#!perl
##############################################################################
#
# Title:  Remove template for App Kit based Recovery Kits
#
# Description:
#   The remove script is used to stop the protected application and 
#   register the outcome of the remove operation with LifeKeeper.  
#   It returns 0 if the protrected resource stope properly.
#   It returns a non-zero code if the resource does not stop properly.
#   This template must be customized to your specific application.
#
# Usage:    remove -t tagname -i id
#
#           where:
#           "tagname" is the resource tag name
#           "id" is the resource ID
#
# Return code:
#   0 - remove successful
#   1 - remove failed
#
# This script is assigned an error code range 27850 - 27899
################### LifeKeeper for  Windows CHANGE LOG #######################
#
#      CR        DATE     DEV     DESCRIPTION 
# =============  =======  ======  ====================================
# lkwin00000588  03/21/02 drk     submit for gen/app kit
#
##############################################################################

BEGIN { require $ENV{'LKROOT'}.'/etc/default/LifeKeeper.pl'; }

use LK;
use POSIX;
use Getopt::Std; # use the standard getopt package

$LKROOT=$ENV{'LKROOT'};
$ResType="app";
$AppType="gen";
$CMD=`basename $0`;
chomp $CMD;

sub parseOptions { # noparams

	getopts('t:i:');
	$tag = "$opt_t";
	$id = "$opt_i";
};

#############################
# Main execution begins here
#############################

# Parse command line options
parseOptions;

########################################################
# Standard setup is done, now perform the desired task 
########################################################

# Perform commands that remove the protected application from service.

# -------------------------------------------------------------------------------------
#                     Custom code goes here

# -------------------------------------------------------------------------------------

# RetCode is used to identify successful or failed remove 
$RetCode = $?>>8; # In perl, the application return code is offset 8 bits.
if ( $RetCode != 0 )
{
	# Log failed remove operation and return.
	`$ENV{'LKROOT'}/bin/lk_err -c FRS_ERR -n 27855 -d TO_STDERR -p $CMD "LifeKeeper: AppKit REMOVE; The \\"$tag\\" resource failed to stop properly.  Return code was \\"$RetCode\\".  Remove has FAILED."`;
	exit $RetCode;
}

# Return success.
exit 0;
