#!perl
##############################################################################
#
# Title:  Restore template for App Kit based Recovery Kits
#
# Description:
#   The restore script is used to start the protected application and 
#   register the outcome of the restore operation with LifeKeeper.  
#   It returns 0 if the protrected resource starts properly.
#   It returns a non-zero code if the resource does not start properly.
#   This template must be customized to your specific application.
#
# Usage:    restore -t tagname -i id
#
#           where:
#           "tagname" is the resource tag name
#           "id" is the resource ID
#
# Return code:
#   0 - restore successful
#   1 - restore failed
#
# This script is assigned an error code range 27450 - 27499
################### LifeKeeper for  Windows CHANGE LOG #######################
#
#      CR        DATE     DEV     DESCRIPTION 
# =============  =======  ======  ====================================
# lkwin00000588  03/21/02 drk     submit for gen/app kit
# 0001           10/19/16 drk     Get IP List from INFO field.          
##############################################################################
##### you must be describe Ping address for detection IP fail.
##### example @PingList=("10.1.6.249" ,"10.1.6.189");
#@PingList=('10.1.6.18' ,'10.1.6.22' ,'10.1.6.44' ,'10.1.6.13' ,'10.1.6.230' ,'10.1.6.249' ,'10.1.6.189');
#@PingList=('10.2.1.216' ,'10.2.1.217' ,'10.2.1.218');

BEGIN { require $ENV{'LKROOT'}.'/etc/default/LifeKeeper.pl'; }

use LK;
use POSIX;
use Getopt::Std; # use the standard getopt package

$LKROOT=$ENV{'LKROOT'};
$ResType="app";
$AppType="gen";
$CMD=`basename $0`;
chomp $CMD;

sub parseOptions { # noparams

	getopts('t:i:');
	$tag = "$opt_t";
	$id = "$opt_i";
};

# 0001 - Retrieve INFO field.
sub getResourceInfo {						# subroutine argument(s):  resource tag 
	my $tag = shift;					# pick up tag field argument
	@_ = LK::ins_list('', '', '', '', $tag, '');		# get resource instance data
	@_ = split /\001/, $_[0];				# fields are Ctrl-A delimited; parse them
	return $_[5];						# return the resource info (6th field) 
};

#############################
# Main execution begins here
#############################

# Parse command line options
parseOptions;

# 0001 Get IP Ping List from INFO Field
my $IPList = getResourceInfo($tag);
if (!IPList) {	# is the info field null?
	`$LKBIN/lk_err -c FRS_ERR -n 27454 -d TO_STDERR -p $CMD "LifeKeeper: Windows IP Companion App RESTORE; The $tag resource info field is null."`;
	exit 1;
}
@PingList = split(" ",$IPList);

########################################################
# Standard setup is done, now perform the desired task 
########################################################

# Perform commands that restore the protected application to service.
# HINT: To fork a new process you can use the LifeKeeper supplied start command
# located at $LKROOT/bin/start.exe and executable in perl as illustrated here.
# For example, to start the Microsoft Notepad accessory as follows:
# system("start", "$ENV{'SystemRoot'}/notepad.exe", "$ENV{'LKROOT'}/TMP/YourFileName.txt"); 

# -------------------------------------------------------------------------------------
#                     Custom code goes here
$pingcheckfail = 1;
$retry = 0;
foreach $PingAddress ( @PingList ) {
#ping results getting(if fail this value will be null)

	printf("PingAddress is %s\r\n", $PingAddress );
	if ( $PingAddress eq '' ) {
		$RetCode = 200; # empty ping address
		next;
	}

	$pingresults =  `ping -n 1 $PingAddress | findstr /c:"TTL="`;
	printf("Pingresults is %s\r\n", $pingresults );
	if ( $pingresults eq '') {
		$pingcheckfail = 1;
	} else {
		$pingcheckfail = 0;
		printf("Pass list #%d IP=%s \r\n",$retry,$PingAddress);
		last; # if ping results not null exit loop
	}
		
	printf("Trying list #%d IP=%s ping fail\r\n",$retry,$PingAddress);
	$retry++;

	sleep 1;
}
$RetCode = $pingcheckfail;
# -------------------------------------------------------------------------------------

# RetCode is used to identify a successful or failed restore 
$RetCode = $?>>8; # In perl, the application return code is offset 8 bits.
if ( $RetCode != 0 )
{
	# Log failed restore and return failed.
	`$ENV{'LKROOT'}/bin/lk_err -c FRS_ERR -n 27455 -d TO_STDERR -p $CMD "LifeKeeper: AppKit RESTORE; The \\"$tag\\" resource failed to start properly.  Return code was \\"$RetCode\\".  Restore has FAILED."`;
	exit $RetCode;
}

# Return success
exit 0;

